#pragma once
#include "Options.h"
#include "Image.h"

namespace graphics {

	/**
	 * PPM options.
	 */
	class PPMOptions : public FormatOptions {
		STORM_CLASS;
	public:
		// Create, default options.
		STORM_CTOR PPMOptions();

		// Store in binary?
		Bool binary;

		// Mode.
		enum Mode {
			// Monochrome, 1bpp
			mono1 = 1,
			// Monochrome, 8bpp
			mono = 2,
			// Color, 24bpp
			color = 3,
		};

		// Mode.
		Mode mode;

		// Create, specify options.
		STORM_CTOR PPMOptions(Bool binary, Mode mode);

		// Load an image, set options.
		virtual Image *STORM_FN load(IStream *from);

		// Save an image according to options.
		virtual void STORM_FN save(Image *image, OStream *to);
		using FormatOptions::load;

		// To string.
		virtual void STORM_FN toS(StrBuf *out) const;
		using FormatOptions::save;
	};


	// Create an ImageFormat. For internal use.
	ImageFormat *ppmFormat(Engine &e);

}
