---
Title: Digraphes
slug: digraphes
layout: page
date: 2025-09-05
lang: fr
---

## Les digraphes

la page /digraph_select permet d'éditer des graphes binaires entre
certaines instances de modèles de SLM et d'autres instances.

Ça peut être un moyen de spécifier des contraintes particulière, en utilisant
une syntaxe propre aux modèles Django, mais avec un feedback visuel qui
met en valeur le graphe qu'on construit.

Pour construire un digraphe, il faut définir :

1. un sélecteur « gauche » ou sélecteur de cause ; pour ce sélecteur,
   trois attributs doivent être définis :
    1. une expression Django qui produit un itérable d'instances de modèles,
       par exemple une requête
    2. le nom d'un attribut de ce modèle, qui sera utilisé comme valeur
    3. le nom d'un attribut de ce modèle, qui sera visible comme étiquette
       dans le graphe
2. un sélecteur « droit » ou sélecteur d'effet ; pour ce sélecteur,
   trois attributs doivent être définis :
    1. une expression Django qui produit un itérable d'instances de modèles,
       par exemple une requête
    2. le nom d'un attribut de ce modèle, qui sera utilisé comme valeur
    3. le nom d'un attribut de ce modèle, qui sera visible comme étiquette
       dans le graphe

Quand ces sélecteurs sont définis, les boutons de test sur la page permettent
de vérifier s'ils sont corrects. Au cas où les sélecteurs seraient corrects,
des séries de boutons colorés apparaissent :

1. sous les sélecteurs « de gauche », les boutons permettent de créer
   un nœud de « cause dans le digraphe »
2. sous les sélecteurs « de droite », les boutons permettent de créer
   un nœud d'« effets dans le digraphe »

Quand tous ces boutons sont bien définis, alors on peut cliquer
alternativement un bouton « de gauche » et un bouton » de droite »,
cela construit, en syntaxe DOT, la structure d'un digraphe ; les nœuds
nécessaires sont créés, et les arêtes du graphe sont définies.

Sous la zone d'édition du digraphe en syntaxe DOT, un bouton permet de
vérifier la syntaxe, et de visualiser le digraphe.

## Utilisation de digraphes pour spécifier des tabous dans la distribution de livres

Il arrive que plusieurs éditions d'un livre avec le même titre soient
présentes en stock. Par exemple, on peut avoir des livres de titre
« Lire les philosophes » d'une édition à couverture blanche, et ceux d'une
édition à couverture marron, qui ne diffèrent que par leurs paginations.
Il ne faut pas que les élèves d'une même classe (et leur professeur) aient
des livres de couleurs variées : la couleur doit être homogène au sein d'une
classe, sinon, il sera difficile de communiquer le numéro d'une page pour
référencer un texte philosophique identique pour tous.

La solution à ce problème consiste à créer des tabous : par exemple, les
élèves des terminales 1 et 2 ne devront pas posséder de livre blanc, ceux des
terminales 3 et 4 ne devront pas posséder de livre marron ; cependant tous
les élèves de terminale devront posséder un livre « Lire les philosophes ».

Pour cela, on construira un système de sélecteur de digraphe, avec le
schéma

Nœuds de gauche :

 - Classes.objects.filter(libelle__contains="TG")
 - libelle
 - libelle

Nœuds de droite :

 - Materiel.objects.filter(titre__icontains="lire les philo")
 - id
 - titre

Ce système de sélecteur sera nommé « tabou_philo » : tous les systèmes
dont le nom commence par tabou_ sont utilisés pour décrire des associations
interdites entre le nom d'une classe (son libellé) et le titre
d'un livre.

En appuyant sur les boutons colorés, on peut construire un graphe qui
donne la solution au problème décrit plus haut. Une fois ce digraphe créé
et enregistré, les listes de livres destinés aux élèves des terminales ne
contiennent plus qu'un seul livre « Lire les philosophes », et celui-ci
a la couleur appropriée à la classe.
