/*
   Unix SMB/CIFS implementation.
   test suite for PAC ndr operations

   Copyright (C) Guenther Deschner 2012

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 3 of the License, or
   (at your option) any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program.  If not, see <http://www.gnu.org/licenses/>.
*/

#include "includes.h"
#include "torture/ndr/ndr.h"
#include "librpc/gen_ndr/ndr_krb5pac.h"
#include "torture/ndr/proto.h"
#include "lib/krb5_wrap/krb5_samba.h"

static const uint8_t PAC_DATA_data[] = {
	0x05, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00,
	0x00, 0x02, 0x00, 0x00, 0x58, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x0a, 0x00, 0x00, 0x00, 0x24, 0x00, 0x00, 0x00, 0x58, 0x02, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x0c, 0x00, 0x00, 0x00, 0x88, 0x00, 0x00, 0x00,
	0x80, 0x02, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x06, 0x00, 0x00, 0x00,
	0x14, 0x00, 0x00, 0x00, 0x08, 0x03, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x07, 0x00, 0x00, 0x00, 0x14, 0x00, 0x00, 0x00, 0x20, 0x03, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x01, 0x10, 0x08, 0x00, 0xcc, 0xcc, 0xcc, 0xcc,
	0xf0, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0x00,
	0xb2, 0x98, 0xae, 0xb6, 0x70, 0xd8, 0xcd, 0x01, 0xff, 0xff, 0xff, 0xff,
	0xff, 0xff, 0xff, 0x7f, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x7f,
	0xb2, 0xd0, 0x46, 0x15, 0x4c, 0xce, 0xcd, 0x01, 0xb2, 0xd0, 0x46, 0x15,
	0x4c, 0xce, 0xcd, 0x01, 0xb2, 0x50, 0xa0, 0x0a, 0x4d, 0xef, 0xcd, 0x01,
	0x1a, 0x00, 0x1a, 0x00, 0x04, 0x00, 0x02, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x08, 0x00, 0x02, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0c, 0x00, 0x02, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x10, 0x00, 0x02, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x14, 0x00, 0x02, 0x00, 0x00, 0x00, 0x00, 0x00, 0x18, 0x00, 0x02, 0x00,
	0x9e, 0x03, 0x00, 0x00, 0xf4, 0x01, 0x00, 0x00, 0x01, 0x02, 0x00, 0x00,
	0x05, 0x00, 0x00, 0x00, 0x1c, 0x00, 0x02, 0x00, 0x20, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x10, 0x00, 0x12, 0x00, 0x20, 0x00, 0x02, 0x00,
	0x0e, 0x00, 0x10, 0x00, 0x24, 0x00, 0x02, 0x00, 0x28, 0x00, 0x02, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x10, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00, 0x2c, 0x00, 0x02, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x0d, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0d, 0x00, 0x00, 0x00,
	0x41, 0x00, 0x64, 0x00, 0x6d, 0x00, 0x69, 0x00, 0x6e, 0x00, 0x69, 0x00,
	0x73, 0x00, 0x74, 0x00, 0x72, 0x00, 0x61, 0x00, 0x74, 0x00, 0x6f, 0x00,
	0x72, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x05, 0x00, 0x00, 0x00, 0x01, 0x02, 0x00, 0x00,
	0x07, 0x00, 0x00, 0x00, 0x08, 0x02, 0x00, 0x00, 0x07, 0x00, 0x00, 0x00,
	0x00, 0x02, 0x00, 0x00, 0x07, 0x00, 0x00, 0x00, 0x06, 0x02, 0x00, 0x00,
	0x07, 0x00, 0x00, 0x00, 0x07, 0x02, 0x00, 0x00, 0x07, 0x00, 0x00, 0x00,
	0x09, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x08, 0x00, 0x00, 0x00,
	0x47, 0x00, 0x44, 0x00, 0x57, 0x00, 0x32, 0x00, 0x4b, 0x00, 0x38, 0x00,
	0x52, 0x00, 0x32, 0x00, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x07, 0x00, 0x00, 0x00, 0x57, 0x00, 0x32, 0x00, 0x4b, 0x00, 0x38, 0x00,
	0x44, 0x00, 0x4f, 0x00, 0x4d, 0x00, 0x00, 0x00, 0x04, 0x00, 0x00, 0x00,
	0x01, 0x04, 0x00, 0x00, 0x00, 0x00, 0x00, 0x05, 0x15, 0x00, 0x00, 0x00,
	0x58, 0xcd, 0x06, 0x06, 0xed, 0x40, 0x2a, 0x76, 0x83, 0xc8, 0xe3, 0x99,
	0x01, 0x00, 0x00, 0x00, 0x30, 0x00, 0x02, 0x00, 0x07, 0x00, 0x00, 0x20,
	0x05, 0x00, 0x00, 0x00, 0x01, 0x05, 0x00, 0x00, 0x00, 0x00, 0x00, 0x05,
	0x15, 0x00, 0x00, 0x00, 0x58, 0xcd, 0x06, 0x06, 0xed, 0x40, 0x2a, 0x76,
	0x83, 0xc8, 0xe3, 0x99, 0x3c, 0x02, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x80, 0x56, 0x9d, 0x59, 0x71, 0xd8, 0xcd, 0x01, 0x1a, 0x00, 0x61, 0x00,
	0x64, 0x00, 0x6d, 0x00, 0x69, 0x00, 0x6e, 0x00, 0x69, 0x00, 0x73, 0x00,
	0x74, 0x00, 0x72, 0x00, 0x61, 0x00, 0x74, 0x00, 0x6f, 0x00, 0x72, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x48, 0x00, 0x10, 0x00, 0x2c, 0x00, 0x58, 0x00,
	0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x41, 0x00, 0x64, 0x00,
	0x6d, 0x00, 0x69, 0x00, 0x6e, 0x00, 0x69, 0x00, 0x73, 0x00, 0x74, 0x00,
	0x72, 0x00, 0x61, 0x00, 0x74, 0x00, 0x6f, 0x00, 0x72, 0x00, 0x40, 0x00,
	0x77, 0x00, 0x32, 0x00, 0x6b, 0x00, 0x38, 0x00, 0x64, 0x00, 0x6f, 0x00,
	0x6d, 0x00, 0x2e, 0x00, 0x62, 0x00, 0x65, 0x00, 0x72, 0x00, 0x2e, 0x00,
	0x72, 0x00, 0x65, 0x00, 0x64, 0x00, 0x68, 0x00, 0x61, 0x00, 0x74, 0x00,
	0x2e, 0x00, 0x63, 0x00, 0x6f, 0x00, 0x6d, 0x00, 0x57, 0x00, 0x32, 0x00,
	0x4b, 0x00, 0x38, 0x00, 0x44, 0x00, 0x4f, 0x00, 0x4d, 0x00, 0x2e, 0x00,
	0x42, 0x00, 0x45, 0x00, 0x52, 0x00, 0x2e, 0x00, 0x52, 0x00, 0x45, 0x00,
	0x44, 0x00, 0x48, 0x00, 0x41, 0x00, 0x54, 0x00, 0x2e, 0x00, 0x43, 0x00,
	0x4f, 0x00, 0x4d, 0x00, 0x00, 0x00, 0x00, 0x00, 0x76, 0xff, 0xff, 0xff,
	0x1a, 0x46, 0xc3, 0x88, 0x72, 0x36, 0xa4, 0x0f, 0x60, 0x0e, 0xed, 0x03,
	0xc8, 0xa6, 0x1a, 0xc4, 0x00, 0x00, 0x00, 0x00, 0x76, 0xff, 0xff, 0xff,
	0xd6, 0x4f, 0xa7, 0xac, 0x53, 0x73, 0x9b, 0x5c, 0xdf, 0xb1, 0xdf, 0xa6,
	0xdd, 0x84, 0x8e, 0xfb, 0x00, 0x00, 0x00, 0x00
};

static bool PAC_DATA_check(struct torture_context *tctx,
			   struct PAC_DATA *r)
{
	int i;

	torture_assert_int_equal(tctx, r->num_buffers, 5, "num_buffers");

	for (i=0; i < r->num_buffers; i++) {
		switch (r->buffers[i].type) {
		case PAC_TYPE_UPN_DNS_INFO:
			torture_assert_int_equal(tctx,
				r->buffers[i].info->upn_dns_info.upn_name_size,
				2*strlen_m("Administrator@w2k8dom.ber.redhat.com"),
				"upn_name_size");
			torture_assert_str_equal(tctx,
				r->buffers[i].info->upn_dns_info.upn_name,
				"Administrator@w2k8dom.ber.redhat.com",
				"upn_name");
			torture_assert_int_equal(tctx,
				r->buffers[i].info->upn_dns_info.dns_domain_name_size,
				2*strlen_m("W2K8DOM.BER.REDHAT.COM"),
				"dns_domain_name_size");
			torture_assert_str_equal(tctx,
				r->buffers[i].info->upn_dns_info.dns_domain_name,
				"W2K8DOM.BER.REDHAT.COM",
				"dns_domain_name");
			break;
		default:
			continue;
		}
	}

	return true;
}

static const uint8_t PAC_DATA_data2[] = {
	0x05, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00,
	0x18, 0x02, 0x00, 0x00, 0x58, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x0a, 0x00, 0x00, 0x00, 0x24, 0x00, 0x00, 0x00, 0x70, 0x02, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x0c, 0x00, 0x00, 0x00, 0x90, 0x00, 0x00, 0x00,
	0x98, 0x02, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x06, 0x00, 0x00, 0x00,
	0x14, 0x00, 0x00, 0x00, 0x28, 0x03, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x07, 0x00, 0x00, 0x00, 0x14, 0x00, 0x00, 0x00, 0x40, 0x03, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x01, 0x10, 0x08, 0x00, 0xcc, 0xcc, 0xcc, 0xcc,
	0x08, 0x02, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0x00,
	0x4f, 0xb3, 0xf4, 0xa3, 0x8d, 0x00, 0xce, 0x01, 0xff, 0xff, 0xff, 0xff,
	0xff, 0xff, 0xff, 0x7f, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x7f,
	0xff, 0xd2, 0x34, 0x6e, 0x6b, 0xfe, 0xcd, 0x01, 0xff, 0x92, 0x9e, 0x98,
	0x34, 0xff, 0xcd, 0x01, 0xff, 0x52, 0x8e, 0x63, 0x6c, 0x1f, 0xce, 0x01,
	0x1a, 0x00, 0x1a, 0x00, 0x04, 0x00, 0x02, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x08, 0x00, 0x02, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0c, 0x00, 0x02, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x10, 0x00, 0x02, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x14, 0x00, 0x02, 0x00, 0x00, 0x00, 0x00, 0x00, 0x18, 0x00, 0x02, 0x00,
	0xc0, 0x00, 0x00, 0x00, 0xf4, 0x01, 0x00, 0x00, 0x01, 0x02, 0x00, 0x00,
	0x05, 0x00, 0x00, 0x00, 0x1c, 0x00, 0x02, 0x00, 0x20, 0x02, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x0e, 0x00, 0x10, 0x00, 0x20, 0x00, 0x02, 0x00,
	0x10, 0x00, 0x12, 0x00, 0x24, 0x00, 0x02, 0x00, 0x28, 0x00, 0x02, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x10, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00, 0x2c, 0x00, 0x02, 0x00,
	0x34, 0x00, 0x02, 0x00, 0x01, 0x00, 0x00, 0x00, 0x38, 0x00, 0x02, 0x00,
	0x0d, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0d, 0x00, 0x00, 0x00,
	0x41, 0x00, 0x64, 0x00, 0x6d, 0x00, 0x69, 0x00, 0x6e, 0x00, 0x69, 0x00,
	0x73, 0x00, 0x74, 0x00, 0x72, 0x00, 0x61, 0x00, 0x74, 0x00, 0x6f, 0x00,
	0x72, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x05, 0x00, 0x00, 0x00, 0x08, 0x02, 0x00, 0x00,
	0x07, 0x00, 0x00, 0x00, 0x00, 0x02, 0x00, 0x00, 0x07, 0x00, 0x00, 0x00,
	0x01, 0x02, 0x00, 0x00, 0x07, 0x00, 0x00, 0x00, 0x06, 0x02, 0x00, 0x00,
	0x07, 0x00, 0x00, 0x00, 0x07, 0x02, 0x00, 0x00, 0x07, 0x00, 0x00, 0x00,
	0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x07, 0x00, 0x00, 0x00,
	0x47, 0x00, 0x44, 0x00, 0x57, 0x00, 0x32, 0x00, 0x4b, 0x00, 0x31, 0x00,
	0x32, 0x00, 0x00, 0x00, 0x09, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x08, 0x00, 0x00, 0x00, 0x57, 0x00, 0x32, 0x00, 0x4b, 0x00, 0x31, 0x00,
	0x32, 0x00, 0x44, 0x00, 0x4f, 0x00, 0x4d, 0x00, 0x04, 0x00, 0x00, 0x00,
	0x01, 0x04, 0x00, 0x00, 0x00, 0x00, 0x00, 0x05, 0x15, 0x00, 0x00, 0x00,
	0x3a, 0x89, 0x96, 0x1a, 0x4d, 0x4c, 0x08, 0xc4, 0xe5, 0x87, 0x18, 0x44,
	0x01, 0x00, 0x00, 0x00, 0x30, 0x00, 0x02, 0x00, 0x07, 0x00, 0x00, 0x00,
	0x01, 0x00, 0x00, 0x00, 0x01, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x12,
	0x01, 0x00, 0x00, 0x00, 0x04, 0x00, 0x00, 0x00, 0x01, 0x04, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x05, 0x15, 0x00, 0x00, 0x00, 0x3a, 0x89, 0x96, 0x1a,
	0x4d, 0x4c, 0x08, 0xc4, 0xe5, 0x87, 0x18, 0x44, 0x01, 0x00, 0x00, 0x00,
	0x3c, 0x02, 0x00, 0x00, 0x07, 0x00, 0x00, 0x20, 0x00, 0x00, 0x00, 0x00,
	0x80, 0x70, 0xe2, 0xbf, 0x8d, 0x00, 0xce, 0x01, 0x1a, 0x00, 0x61, 0x00,
	0x64, 0x00, 0x6d, 0x00, 0x69, 0x00, 0x6e, 0x00, 0x69, 0x00, 0x73, 0x00,
	0x74, 0x00, 0x72, 0x00, 0x61, 0x00, 0x74, 0x00, 0x6f, 0x00, 0x72, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x4a, 0x00, 0x10, 0x00, 0x2e, 0x00, 0x60, 0x00,
	0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x41, 0x00, 0x64, 0x00,
	0x6d, 0x00, 0x69, 0x00, 0x6e, 0x00, 0x69, 0x00, 0x73, 0x00, 0x74, 0x00,
	0x72, 0x00, 0x61, 0x00, 0x74, 0x00, 0x6f, 0x00, 0x72, 0x00, 0x40, 0x00,
	0x77, 0x00, 0x32, 0x00, 0x6b, 0x00, 0x31, 0x00, 0x32, 0x00, 0x64, 0x00,
	0x6f, 0x00, 0x6d, 0x00, 0x2e, 0x00, 0x62, 0x00, 0x65, 0x00, 0x72, 0x00,
	0x2e, 0x00, 0x72, 0x00, 0x65, 0x00, 0x64, 0x00, 0x68, 0x00, 0x61, 0x00,
	0x74, 0x00, 0x2e, 0x00, 0x63, 0x00, 0x6f, 0x00, 0x6d, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x57, 0x00, 0x32, 0x00, 0x4b, 0x00, 0x31, 0x00,
	0x32, 0x00, 0x44, 0x00, 0x4f, 0x00, 0x4d, 0x00, 0x2e, 0x00, 0x42, 0x00,
	0x45, 0x00, 0x52, 0x00, 0x2e, 0x00, 0x52, 0x00, 0x45, 0x00, 0x44, 0x00,
	0x48, 0x00, 0x41, 0x00, 0x54, 0x00, 0x2e, 0x00, 0x43, 0x00, 0x4f, 0x00,
	0x4d, 0x00, 0x00, 0x00, 0x76, 0xff, 0xff, 0xff, 0xa9, 0x20, 0x93, 0x4b,
	0x8e, 0xc6, 0x88, 0x88, 0x7a, 0xd6, 0x12, 0xc6, 0xf3, 0x6f, 0x98, 0x3f,
	0x00, 0x00, 0x00, 0x00, 0x76, 0xff, 0xff, 0xff, 0xd5, 0xfe, 0x5a, 0x1e,
	0x73, 0xa4, 0x22, 0x64, 0x48, 0x72, 0x2d, 0xd8, 0x0f, 0xef, 0xe5, 0x81,
	0x00, 0x00, 0x00, 0x00
};

static bool PAC_DATA_check2(struct torture_context *tctx,
			    struct PAC_DATA *r)
{
	int i;

	torture_assert_int_equal(tctx, r->num_buffers, 5, "num_buffers");

	for (i=0; i < r->num_buffers; i++) {
		switch (r->buffers[i].type) {
		case PAC_TYPE_UPN_DNS_INFO:
			torture_assert_int_equal(tctx,
				r->buffers[i].info->upn_dns_info.upn_name_size,
				2*strlen_m("Administrator@w2k12dom.ber.redhat.com"),
				"upn_name_size");
			torture_assert_str_equal(tctx,
				r->buffers[i].info->upn_dns_info.upn_name,
				"Administrator@w2k12dom.ber.redhat.com",
				"upn_name");
			torture_assert_int_equal(tctx,
				r->buffers[i].info->upn_dns_info.dns_domain_name_size,
				2*strlen_m("W2K12DOM.BER.REDHAT.COM"),
				"dns_domain_name_size");
			torture_assert_str_equal(tctx,
				r->buffers[i].info->upn_dns_info.dns_domain_name,
				"W2K12DOM.BER.REDHAT.COM",
				"dns_domain_name");
			break;
		default:
			continue;
		}
	}

	return true;
}

/* Thanks to Tris Mabbs <TM-Samba201302 at Firstgrade.Co.UK> for this sample. */

static const uint8_t PAC_DATA_data3[] = {
	0x05, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00, 0x48, 0x02, 0x00, 0x00,
	0x58, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0a, 0x00, 0x00, 0x00, 0x10, 0x00, 0x00, 0x00,
	0xa0, 0x02, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0c, 0x00, 0x00, 0x00, 0x58, 0x00, 0x00, 0x00,
	0xb0, 0x02, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x06, 0x00, 0x00, 0x00, 0x14, 0x00, 0x00, 0x00,
	0x08, 0x03, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x07, 0x00, 0x00, 0x00, 0x14, 0x00, 0x00, 0x00,
	0x20, 0x03, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x01, 0x10, 0x08, 0x00, 0xcc, 0xcc, 0xcc, 0xcc,
	0x38, 0x02, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0x00, 0xac, 0x03, 0xe5, 0x76,
	0xaa, 0x13, 0xce, 0x01, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x7f, 0xff, 0xff, 0xff, 0xff,
	0xff, 0xff, 0xff, 0x7f, 0x9d, 0x37, 0xcc, 0x87, 0x4d, 0x13, 0xce, 0x01, 0x9d, 0xf7, 0x35, 0xb2,
	0x16, 0x14, 0xce, 0x01, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x7f, 0x06, 0x00, 0x06, 0x00,
	0x04, 0x00, 0x02, 0x00, 0x06, 0x00, 0x06, 0x00, 0x08, 0x00, 0x02, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x0c, 0x00, 0x02, 0x00, 0x24, 0x00, 0x24, 0x00, 0x10, 0x00, 0x02, 0x00, 0x22, 0x00, 0x22, 0x00,
	0x14, 0x00, 0x02, 0x00, 0x04, 0x00, 0x04, 0x00, 0x18, 0x00, 0x02, 0x00, 0x3a, 0x00, 0x00, 0x00,
	0x5b, 0x08, 0x00, 0x00, 0x01, 0x02, 0x00, 0x00, 0x0b, 0x00, 0x00, 0x00, 0x1c, 0x00, 0x02, 0x00,
	0x20, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x0e, 0x00, 0x10, 0x00, 0x20, 0x00, 0x02, 0x00, 0x14, 0x00, 0x16, 0x00,
	0x24, 0x00, 0x02, 0x00, 0x28, 0x00, 0x02, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x10, 0x0a, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x03, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x03, 0x00, 0x00, 0x00,
	0x64, 0x00, 0x6d, 0x00, 0x7a, 0x00, 0x00, 0x00, 0x03, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x03, 0x00, 0x00, 0x00, 0x44, 0x00, 0x4d, 0x00, 0x5a, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x12, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x12, 0x00, 0x00, 0x00, 0x5c, 0x00, 0x5c, 0x00, 0x47, 0x00, 0x61, 0x00, 0x74, 0x00, 0x65, 0x00,
	0x77, 0x00, 0x61, 0x00, 0x79, 0x00, 0x5c, 0x00, 0x50, 0x00, 0x72, 0x00, 0x6f, 0x00, 0x66, 0x00,
	0x69, 0x00, 0x6c, 0x00, 0x65, 0x00, 0x73, 0x00, 0x11, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x11, 0x00, 0x00, 0x00, 0x5c, 0x00, 0x5c, 0x00, 0x47, 0x00, 0x61, 0x00, 0x74, 0x00, 0x65, 0x00,
	0x77, 0x00, 0x61, 0x00, 0x79, 0x00, 0x5c, 0x00, 0x57, 0x00, 0x69, 0x00, 0x6e, 0x00, 0x64, 0x00,
	0x6f, 0x00, 0x77, 0x00, 0x73, 0x00, 0x00, 0x00, 0x02, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x02, 0x00, 0x00, 0x00, 0x4e, 0x00, 0x3a, 0x00, 0x0b, 0x00, 0x00, 0x00, 0x6d, 0x04, 0x00, 0x00,
	0x07, 0x00, 0x00, 0x00, 0x50, 0x08, 0x00, 0x00, 0x07, 0x00, 0x00, 0x00, 0x4c, 0x08, 0x00, 0x00,
	0x07, 0x00, 0x00, 0x00, 0x6b, 0x04, 0x00, 0x00, 0x07, 0x00, 0x00, 0x00, 0x55, 0x08, 0x00, 0x00,
	0x07, 0x00, 0x00, 0x00, 0x53, 0x08, 0x00, 0x00, 0x07, 0x00, 0x00, 0x00, 0x01, 0x02, 0x00, 0x00,
	0x07, 0x00, 0x00, 0x00, 0x6c, 0x04, 0x00, 0x00, 0x07, 0x00, 0x00, 0x00, 0x9d, 0x04, 0x00, 0x00,
	0x07, 0x00, 0x00, 0x00, 0x7a, 0x04, 0x00, 0x00, 0x07, 0x00, 0x00, 0x00, 0x5d, 0x04, 0x00, 0x00,
	0x07, 0x00, 0x00, 0x00, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x07, 0x00, 0x00, 0x00,
	0x47, 0x00, 0x45, 0x00, 0x44, 0x00, 0x49, 0x00, 0x4d, 0x00, 0x41, 0x00, 0x4e, 0x00, 0x00, 0x00,
	0x0b, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0a, 0x00, 0x00, 0x00, 0x46, 0x00, 0x49, 0x00,
	0x52, 0x00, 0x53, 0x00, 0x54, 0x00, 0x47, 0x00, 0x52, 0x00, 0x41, 0x00, 0x44, 0x00, 0x45, 0x00,
	0x04, 0x00, 0x00, 0x00, 0x01, 0x04, 0x00, 0x00, 0x00, 0x00, 0x00, 0x05, 0x15, 0x00, 0x00, 0x00,
	0x7d, 0xbc, 0x30, 0x51, 0xd8, 0x07, 0x05, 0x60, 0x40, 0x59, 0x47, 0xb5, 0x00, 0x00, 0x00, 0x00,
	0x00, 0xbd, 0xde, 0x76, 0xaa, 0x13, 0xce, 0x01, 0x06, 0x00, 0x64, 0x00, 0x6d, 0x00, 0x7a, 0x00,
	0x28, 0x00, 0x10, 0x00, 0x20, 0x00, 0x38, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x64, 0x00, 0x6d, 0x00, 0x7a, 0x00, 0x40, 0x00, 0x46, 0x00, 0x69, 0x00, 0x72, 0x00, 0x73, 0x00,
	0x74, 0x00, 0x67, 0x00, 0x72, 0x00, 0x61, 0x00, 0x64, 0x00, 0x65, 0x00, 0x2e, 0x00, 0x43, 0x00,
	0x6f, 0x00, 0x2e, 0x00, 0x55, 0x00, 0x4b, 0x00, 0x46, 0x00, 0x49, 0x00, 0x52, 0x00, 0x53, 0x00,
	0x54, 0x00, 0x47, 0x00, 0x52, 0x00, 0x41, 0x00, 0x44, 0x00, 0x45, 0x00, 0x2e, 0x00, 0x43, 0x00,
	0x4f, 0x00, 0x2e, 0x00, 0x55, 0x00, 0x4b, 0x00, 0x76, 0xff, 0xff, 0xff, 0xff, 0x37, 0xcd, 0x48,
	0x1b, 0x6f, 0x9f, 0xca, 0x37, 0xe1, 0x02, 0x1c, 0xaa, 0x46, 0x0a, 0xf4, 0x00, 0x00, 0x00, 0x00,
	0x76, 0xff, 0xff, 0xff, 0x3b, 0x96, 0xcc, 0xbb, 0xbb, 0x9d, 0xe4, 0x57, 0x13, 0xc9, 0x6d, 0x1c,
	0x65, 0xa0, 0xb1, 0x1b, 0x00, 0x00, 0x00, 0x00
};

static const uint8_t PAC_DATA_pkinit_AS[] = {
	0x06, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00, 0xc0, 0x01, 0x00, 0x00,
	0x68, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0x00, 0x00, 0x00, 0x94, 0x00, 0x00, 0x00,
	0x28, 0x02, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0a, 0x00, 0x00, 0x00, 0x18, 0x00, 0x00, 0x00,
	0xc0, 0x02, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0c, 0x00, 0x00, 0x00, 0x60, 0x00, 0x00, 0x00,
	0xd8, 0x02, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x06, 0x00, 0x00, 0x00, 0x10, 0x00, 0x00, 0x00,
	0x38, 0x03, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x07, 0x00, 0x00, 0x00, 0x14, 0x00, 0x00, 0x00,
	0x48, 0x03, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x01, 0x10, 0x08, 0x00, 0xcc, 0xcc, 0xcc, 0xcc,
	0xb0, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0x00, 0xa2, 0xd4, 0x65, 0xa4,
	0x59, 0x48, 0xd1, 0x01, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x7f, 0xff, 0xff, 0xff, 0xff,
	0xff, 0xff, 0xff, 0x7f, 0x70, 0x0b, 0xe4, 0x66, 0x97, 0x47, 0xd1, 0x01, 0x70, 0xcb, 0x4d, 0x91,
	0x60, 0x48, 0xd1, 0x01, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x7f, 0x0e, 0x00, 0x0e, 0x00,
	0x04, 0x00, 0x02, 0x00, 0x0e, 0x00, 0x0e, 0x00, 0x08, 0x00, 0x02, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x0c, 0x00, 0x02, 0x00, 0x00, 0x00, 0x00, 0x00, 0x10, 0x00, 0x02, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x14, 0x00, 0x02, 0x00, 0x00, 0x00, 0x00, 0x00, 0x18, 0x00, 0x02, 0x00, 0x15, 0x00, 0x00, 0x00,
	0x50, 0x04, 0x00, 0x00, 0x01, 0x02, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00, 0x1c, 0x00, 0x02, 0x00,
	0x20, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x16, 0x00, 0x18, 0x00, 0x20, 0x00, 0x02, 0x00, 0x12, 0x00, 0x14, 0x00,
	0x24, 0x00, 0x02, 0x00, 0x28, 0x00, 0x02, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x10, 0x02, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x07, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x07, 0x00, 0x00, 0x00,
	0x70, 0x00, 0x6b, 0x00, 0x69, 0x00, 0x6e, 0x00, 0x69, 0x00, 0x74, 0x00, 0x31, 0x00, 0x00, 0x00,
	0x07, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x07, 0x00, 0x00, 0x00, 0x50, 0x00, 0x4b, 0x00,
	0x20, 0x00, 0x49, 0x00, 0x4e, 0x00, 0x49, 0x00, 0x54, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00,
	0x01, 0x02, 0x00, 0x00, 0x07, 0x00, 0x00, 0x00, 0x0c, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x0b, 0x00, 0x00, 0x00, 0x57, 0x00, 0x32, 0x00, 0x30, 0x00, 0x30, 0x00, 0x38, 0x00, 0x52, 0x00,
	0x32, 0x00, 0x2d, 0x00, 0x31, 0x00, 0x33, 0x00, 0x33, 0x00, 0x00, 0x00, 0x0a, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x09, 0x00, 0x00, 0x00, 0x57, 0x00, 0x34, 0x00, 0x45, 0x00, 0x44, 0x00,
	0x4f, 0x00, 0x4d, 0x00, 0x2d, 0x00, 0x4c, 0x00, 0x34, 0x00, 0x00, 0x00, 0x04, 0x00, 0x00, 0x00,
	0x01, 0x04, 0x00, 0x00, 0x00, 0x00, 0x00, 0x05, 0x15, 0x00, 0x00, 0x00, 0x55, 0x93, 0x92, 0x10,
	0xf4, 0xb0, 0xa6, 0xca, 0x96, 0x47, 0x97, 0x56, 0x00, 0x00, 0x00, 0x00, 0x12, 0x00, 0x00, 0x00,
	0xdc, 0xb1, 0xe1, 0x35, 0x5f, 0x4d, 0xa7, 0xef, 0x84, 0x86, 0x04, 0x42, 0x9f, 0x4f, 0x5e, 0x5b,
	0x22, 0x14, 0x66, 0x04, 0xc4, 0xf4, 0x18, 0x8d, 0x53, 0x30, 0xbe, 0x8c, 0xf4, 0xf7, 0x50, 0x0a,
	0x87, 0xef, 0x73, 0x3d, 0xd7, 0x7a, 0x0b, 0xf3, 0xd7, 0x30, 0x57, 0xb7, 0x1a, 0x1b, 0x8a, 0x35,
	0xc2, 0xde, 0x5b, 0xed, 0x4a, 0x25, 0xad, 0xc5, 0x15, 0x1b, 0xfc, 0xaf, 0x00, 0xb5, 0x7a, 0xea,
	0xda, 0xad, 0x77, 0x75, 0xf0, 0xf6, 0x17, 0x46, 0xf3, 0x5f, 0x7e, 0x89, 0x0c, 0xb3, 0x70, 0x31,
	0x09, 0x23, 0x16, 0x00, 0x9a, 0xf4, 0x03, 0x5f, 0xd4, 0xab, 0x3b, 0x6a, 0xc2, 0x7d, 0xb3, 0x8a,
	0x61, 0x8d, 0x15, 0xfb, 0x43, 0x38, 0x3d, 0x3b, 0x77, 0xda, 0xf4, 0x66, 0x0c, 0x0d, 0x36, 0xf5,
	0xc7, 0x01, 0xf9, 0xfb, 0xa4, 0xf8, 0x1f, 0xb8, 0x55, 0x65, 0x7a, 0xc2, 0xf3, 0x23, 0x8f, 0x9b,
	0x1e, 0xf1, 0xb8, 0x56, 0x70, 0x01, 0x75, 0xb4, 0x7d, 0xcb, 0x04, 0xbe, 0x00, 0x00, 0x00, 0x00,
	0x80, 0x09, 0x4e, 0x6f, 0x33, 0x49, 0xd1, 0x01, 0x0e, 0x00, 0x70, 0x00, 0x6b, 0x00, 0x69, 0x00,
	0x6e, 0x00, 0x69, 0x00, 0x74, 0x00, 0x31, 0x00, 0x2c, 0x00, 0x10, 0x00, 0x1c, 0x00, 0x40, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x70, 0x00, 0x6b, 0x00, 0x69, 0x00, 0x6e, 0x00,
	0x69, 0x00, 0x74, 0x00, 0x31, 0x00, 0x40, 0x00, 0x77, 0x00, 0x34, 0x00, 0x65, 0x00, 0x64, 0x00,
	0x6f, 0x00, 0x6d, 0x00, 0x2d, 0x00, 0x6c, 0x00, 0x34, 0x00, 0x2e, 0x00, 0x62, 0x00, 0x61, 0x00,
	0x73, 0x00, 0x65, 0x00, 0x00, 0x00, 0x00, 0x00, 0x57, 0x00, 0x34, 0x00, 0x45, 0x00, 0x44, 0x00,
	0x4f, 0x00, 0x4d, 0x00, 0x2d, 0x00, 0x4c, 0x00, 0x34, 0x00, 0x2e, 0x00, 0x42, 0x00, 0x41, 0x00,
	0x53, 0x00, 0x45, 0x00, 0x00, 0x00, 0x00, 0x00, 0x10, 0x00, 0x00, 0x00, 0xc2, 0x78, 0x2b, 0x92,
	0x2c, 0x06, 0x36, 0x32, 0xb0, 0x72, 0x75, 0x9a, 0x76, 0xff, 0xff, 0xff, 0x9c, 0x73, 0x1e, 0xb8,
	0x3a, 0xd8, 0xca, 0x01, 0x53, 0x60, 0xd4, 0x1d, 0x1a, 0x69, 0xde, 0x38, 0x00, 0x00, 0x00, 0x00,
};

static const uint8_t PAC_DATA_pkinit_TGS[] = {
	0x06, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00, 0xc0, 0x01, 0x00, 0x00,
	0x68, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0x00, 0x00, 0x00, 0x94, 0x00, 0x00, 0x00,
	0x28, 0x02, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0a, 0x00, 0x00, 0x00, 0x18, 0x00, 0x00, 0x00,
	0xc0, 0x02, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0c, 0x00, 0x00, 0x00, 0x60, 0x00, 0x00, 0x00,
	0xd8, 0x02, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x06, 0x00, 0x00, 0x00, 0x10, 0x00, 0x00, 0x00,
	0x38, 0x03, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x07, 0x00, 0x00, 0x00, 0x14, 0x00, 0x00, 0x00,
	0x48, 0x03, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x01, 0x10, 0x08, 0x00, 0xcc, 0xcc, 0xcc, 0xcc,
	0xb0, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0x00, 0xa2, 0xd4, 0x65, 0xa4,
	0x59, 0x48, 0xd1, 0x01, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x7f, 0xff, 0xff, 0xff, 0xff,
	0xff, 0xff, 0xff, 0x7f, 0x70, 0x0b, 0xe4, 0x66, 0x97, 0x47, 0xd1, 0x01, 0x70, 0xcb, 0x4d, 0x91,
	0x60, 0x48, 0xd1, 0x01, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x7f, 0x0e, 0x00, 0x0e, 0x00,
	0x04, 0x00, 0x02, 0x00, 0x0e, 0x00, 0x0e, 0x00, 0x08, 0x00, 0x02, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x0c, 0x00, 0x02, 0x00, 0x00, 0x00, 0x00, 0x00, 0x10, 0x00, 0x02, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x14, 0x00, 0x02, 0x00, 0x00, 0x00, 0x00, 0x00, 0x18, 0x00, 0x02, 0x00, 0x15, 0x00, 0x00, 0x00,
	0x50, 0x04, 0x00, 0x00, 0x01, 0x02, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00, 0x1c, 0x00, 0x02, 0x00,
	0x20, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x16, 0x00, 0x18, 0x00, 0x20, 0x00, 0x02, 0x00, 0x12, 0x00, 0x14, 0x00,
	0x24, 0x00, 0x02, 0x00, 0x28, 0x00, 0x02, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x10, 0x02, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x07, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x07, 0x00, 0x00, 0x00,
	0x70, 0x00, 0x6b, 0x00, 0x69, 0x00, 0x6e, 0x00, 0x69, 0x00, 0x74, 0x00, 0x31, 0x00, 0x00, 0x00,
	0x07, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x07, 0x00, 0x00, 0x00, 0x50, 0x00, 0x4b, 0x00,
	0x20, 0x00, 0x49, 0x00, 0x4e, 0x00, 0x49, 0x00, 0x54, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00,
	0x01, 0x02, 0x00, 0x00, 0x07, 0x00, 0x00, 0x00, 0x0c, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x0b, 0x00, 0x00, 0x00, 0x57, 0x00, 0x32, 0x00, 0x30, 0x00, 0x30, 0x00, 0x38, 0x00, 0x52, 0x00,
	0x32, 0x00, 0x2d, 0x00, 0x31, 0x00, 0x33, 0x00, 0x33, 0x00, 0x00, 0x00, 0x0a, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x09, 0x00, 0x00, 0x00, 0x57, 0x00, 0x34, 0x00, 0x45, 0x00, 0x44, 0x00,
	0x4f, 0x00, 0x4d, 0x00, 0x2d, 0x00, 0x4c, 0x00, 0x34, 0x00, 0x00, 0x00, 0x04, 0x00, 0x00, 0x00,
	0x01, 0x04, 0x00, 0x00, 0x00, 0x00, 0x00, 0x05, 0x15, 0x00, 0x00, 0x00, 0x55, 0x93, 0x92, 0x10,
	0xf4, 0xb0, 0xa6, 0xca, 0x96, 0x47, 0x97, 0x56, 0x00, 0x00, 0x00, 0x00, 0x12, 0x00, 0x00, 0x00,
	0xdc, 0xb1, 0xe1, 0x35, 0x5f, 0x4d, 0xa7, 0xef, 0x84, 0x86, 0x04, 0x42, 0x9f, 0x4f, 0x5e, 0x5b,
	0x22, 0x14, 0x66, 0x04, 0xc4, 0xf4, 0x18, 0x8d, 0x53, 0x30, 0xbe, 0x8c, 0xf4, 0xf7, 0x50, 0x0a,
	0x87, 0xef, 0x73, 0x3d, 0xd7, 0x7a, 0x0b, 0xf3, 0xd7, 0x30, 0x57, 0xb7, 0x1a, 0x1b, 0x8a, 0x35,
	0xc2, 0xde, 0x5b, 0xed, 0x4a, 0x25, 0xad, 0xc5, 0x15, 0x1b, 0xfc, 0xaf, 0x00, 0xb5, 0x7a, 0xea,
	0xda, 0xad, 0x77, 0x75, 0xf0, 0xf6, 0x17, 0x46, 0xf3, 0x5f, 0x7e, 0x89, 0x0c, 0xb3, 0x70, 0x31,
	0x09, 0x23, 0x16, 0x00, 0x9a, 0xf4, 0x03, 0x5f, 0xd4, 0xab, 0x3b, 0x6a, 0xc2, 0x7d, 0xb3, 0x8a,
	0x61, 0x8d, 0x15, 0xfb, 0x43, 0x38, 0x3d, 0x3b, 0x77, 0xda, 0xf4, 0x66, 0x0c, 0x0d, 0x36, 0xf5,
	0xc7, 0x01, 0xf9, 0xfb, 0xa4, 0xf8, 0x1f, 0xb8, 0x55, 0x65, 0x7a, 0xc2, 0xf3, 0x23, 0x8f, 0x9b,
	0x1e, 0xf1, 0xb8, 0x56, 0x70, 0x01, 0x75, 0xb4, 0x7d, 0xcb, 0x04, 0xbe, 0x00, 0x00, 0x00, 0x00,
	0x80, 0x09, 0x4e, 0x6f, 0x33, 0x49, 0xd1, 0x01, 0x0e, 0x00, 0x70, 0x00, 0x6b, 0x00, 0x69, 0x00,
	0x6e, 0x00, 0x69, 0x00, 0x74, 0x00, 0x31, 0x00, 0x2c, 0x00, 0x10, 0x00, 0x1c, 0x00, 0x40, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x70, 0x00, 0x6b, 0x00, 0x69, 0x00, 0x6e, 0x00,
	0x69, 0x00, 0x74, 0x00, 0x31, 0x00, 0x40, 0x00, 0x77, 0x00, 0x34, 0x00, 0x65, 0x00, 0x64, 0x00,
	0x6f, 0x00, 0x6d, 0x00, 0x2d, 0x00, 0x6c, 0x00, 0x34, 0x00, 0x2e, 0x00, 0x62, 0x00, 0x61, 0x00,
	0x73, 0x00, 0x65, 0x00, 0x00, 0x00, 0x00, 0x00, 0x57, 0x00, 0x34, 0x00, 0x45, 0x00, 0x44, 0x00,
	0x4f, 0x00, 0x4d, 0x00, 0x2d, 0x00, 0x4c, 0x00, 0x34, 0x00, 0x2e, 0x00, 0x42, 0x00, 0x41, 0x00,
	0x53, 0x00, 0x45, 0x00, 0x00, 0x00, 0x00, 0x00, 0x10, 0x00, 0x00, 0x00, 0x82, 0xcd, 0xb1, 0x67,
	0xaa, 0x7c, 0xca, 0xa5, 0x0c, 0xf0, 0xbe, 0x75, 0x76, 0xff, 0xff, 0xff, 0x8b, 0x4e, 0xb0, 0x67,
	0x3c, 0x17, 0xe6, 0x05, 0x90, 0x66, 0x20, 0x45, 0x34, 0x2f, 0x32, 0x9b, 0x00, 0x00, 0x00, 0x00,
};

static const uint8_t PAC_DATA_pkinit_PAC_CREDENTIAL_DATA_NDR[] = {
	0x01, 0x10, 0x08, 0x00, 0xcc, 0xcc, 0xcc, 0xcc, 0x60, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x02, 0x00, 0x01, 0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00, 0x08, 0x00, 0x08, 0x00,
	0x04, 0x00, 0x02, 0x00, 0x28, 0x00, 0x00, 0x00, 0x08, 0x00, 0x02, 0x00, 0x04, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x04, 0x00, 0x00, 0x00, 0x4e, 0x00, 0x54, 0x00, 0x4c, 0x00, 0x4d, 0x00,
	0x28, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x12, 0x3e, 0x95, 0x63,
	0x88, 0x8b, 0x12, 0x02, 0x9f, 0x6e, 0x2b, 0x8d, 0xf6, 0x9a, 0x6e, 0xb3, 0x00, 0x00, 0x00, 0x00,
};

static const uint8_t PAC_DATA_pkinit_PAC_CREDENTIAL_NTLM_SECPKG[] = {
	0x00, 0x00, 0x00, 0x00, 0x02, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x12, 0x3e, 0x95, 0x63, 0x88, 0x8b, 0x12, 0x02,
	0x9f, 0x6e, 0x2b, 0x8d, 0xf6, 0x9a, 0x6e, 0xb3,
};

static bool PAC_DATA_pkinit(struct torture_context *tctx,
			    struct PAC_DATA *r)
{
	DATA_BLOB reply_key_blob = data_blob_null;
	krb5_context ctx;
	krb5_keyblock reply_key;
	krb5_enc_data input;
	krb5_data plain_data;
	DATA_BLOB plain_data_blob = data_blob_null;

	torture_assert_int_equal(tctx, r->version, 0, "version");

	torture_assert_int_equal(tctx, r->num_buffers, 6, "num_buffers");

	torture_assert_int_equal(tctx, r->buffers[0].type, PAC_TYPE_LOGON_INFO, "PAC_TYPE_LOGON_INFO");
	torture_assert_int_equal(tctx, r->buffers[0]._ndr_size, 448, "PAC_TYPE_LOGON_INFO _ndr_size");
	torture_assert(tctx, r->buffers[0].info != NULL, "PAC_TYPE_LOGON_INFO info");

	torture_assert_int_equal(tctx, r->buffers[1].type, PAC_TYPE_CREDENTIAL_INFO, "PAC_TYPE_CREDENTIAL_INFO");
	torture_assert_int_equal(tctx, r->buffers[1]._ndr_size, 148, "PAC_TYPE_CREDENTIALS_INFO _ndr_size");
	torture_assert(tctx, r->buffers[1].info != NULL, "PAC_TYPE_CREDENTIALS_INFO info");
	torture_assert_int_equal(tctx,
		r->buffers[1].info->credential_info.version,
		0,
		"PAC_TYPE_CREDENTIALS_INFO version");
	torture_assert_int_equal(tctx,
		r->buffers[1].info->credential_info.encryption_type,
		ENCTYPE_AES256_CTS_HMAC_SHA1_96,
		"PAC_TYPE_CREDENTIALS_INFO encryption_type");
	torture_assert_data_blob_equal(tctx,
		r->buffers[1].info->credential_info.encrypted_data,
		data_blob_const(PAC_DATA_pkinit_AS+0x230, 140),
		"PAC_TYPE_CREDENTIALS_INFO encrypted_data");

	/*
	 * This is the PKINIT based reply key.
	 */
	reply_key_blob = strhex_to_data_blob(tctx,
		"c9deb5412b3fba34250b0e4b1f3b6cba3d70bdcdac0f097a9b6a7c763a5524ed");
	torture_assert_int_equal(tctx, reply_key_blob.length, 32, "reply_key_blob.length");
	torture_assert_int_equal(tctx, krb5_init_context(&ctx), 0, "krb5_init_context");
	torture_assert_int_equal(tctx, smb_krb5_keyblock_init_contents(ctx,
					ENCTYPE_AES256_CTS_HMAC_SHA1_96,
					reply_key_blob.data, reply_key_blob.length,
					&reply_key), 0,
				"smb_krb5_keyblock_init_contents");

	ZERO_STRUCT(input);

	input.ciphertext.data = (char *)r->buffers[1].info->credential_info.encrypted_data.data;
	input.ciphertext.length = r->buffers[1].info->credential_info.encrypted_data.length;
	input.enctype = ENCTYPE_AES256_CTS_HMAC_SHA1_96;

	plain_data.data = malloc(r->buffers[1].info->credential_info.encrypted_data.length);
	plain_data.length = r->buffers[1].info->credential_info.encrypted_data.length;
	torture_assert(tctx, plain_data.data, "malloc failed");

	torture_assert_krb5_error_equal(tctx, krb5_c_decrypt(ctx,
#ifdef SAMBA4_USES_HEIMDAL
					reply_key,
#else
					&reply_key,
#endif
					KRB5_KU_OTHER_ENCRYPTED,
					NULL,
					&input,
					&plain_data), 0,
				"krb5_decrypt");

	torture_assert_int_equal(tctx, plain_data.length, 112, "plain_data.length");
	plain_data_blob = data_blob_talloc(tctx, plain_data.data, plain_data.length);
	torture_assert_int_equal(tctx, plain_data_blob.length, 112, "plain_data_blob.length");
	smb_krb5_free_data_contents(ctx, &plain_data);
	krb5_free_keyblock_contents(ctx, &reply_key);
	krb5_free_context(ctx);
	torture_assert_data_blob_equal(tctx,
		plain_data_blob,
		data_blob_const(PAC_DATA_pkinit_PAC_CREDENTIAL_DATA_NDR,
				sizeof(PAC_DATA_pkinit_PAC_CREDENTIAL_DATA_NDR)),
		"PAC_CREDENTIALS_DATA_NDR plain_data");

	torture_assert_int_equal(tctx, r->buffers[2].type, PAC_TYPE_LOGON_NAME, "PAC_TYPE_LOGON_NAME");
	torture_assert_int_equal(tctx, r->buffers[2]._ndr_size, 24, "PAC_TYPE_LOGON_NAME _ndr_size");
	torture_assert(tctx, r->buffers[2].info != NULL, "PAC_TYPE_LOGON_NAME info");
	torture_assert_int_equal(tctx,
		r->buffers[2].info->logon_name.size,
		2*strlen_m("pkinit1"),
		"size");
	torture_assert_str_equal(tctx,
		r->buffers[2].info->logon_name.account_name,
		"pkinit1",
		"account_name");
	torture_assert_u64_equal(tctx,
		r->buffers[2].info->logon_name.logon_time,
		130966349430000000ULL,
		"logon_time");

	torture_assert_int_equal(tctx, r->buffers[3].type, PAC_TYPE_UPN_DNS_INFO, "PAC_TYPE_UPN_DNS_INFO");
	torture_assert_int_equal(tctx, r->buffers[3]._ndr_size, 96, "PAC_TYPE_UPN_DNS_INFO _ndr_size");
	torture_assert(tctx, r->buffers[3].info != NULL, "PAC_TYPE_UPN_DNS_INFO info");
	torture_assert_int_equal(tctx,
		r->buffers[3].info->upn_dns_info.upn_name_size,
		2*strlen_m("pkinit1@w4edom-l4.base"),
		"upn_name_size");
	torture_assert_str_equal(tctx,
		r->buffers[3].info->upn_dns_info.upn_name,
		"pkinit1@w4edom-l4.base",
		"upn_name");
	torture_assert_int_equal(tctx,
		r->buffers[3].info->upn_dns_info.dns_domain_name_size,
		2*strlen_m("W4EDOM-L4.BASE"),
		"dns_domain_name_size");
	torture_assert_str_equal(tctx,
		r->buffers[3].info->upn_dns_info.dns_domain_name,
		"W4EDOM-L4.BASE",
		"dns_domain_name");

	torture_assert_int_equal(tctx, r->buffers[4].type, PAC_TYPE_SRV_CHECKSUM, "PAC_TYPE_SRV_CHECKSUM");
	torture_assert_int_equal(tctx, r->buffers[4]._ndr_size, 16, "PAC_TYPE_SRV_CHECKSUM _ndr_size");
	torture_assert(tctx, r->buffers[4].info != NULL, "PAC_TYPE_SRV_CHECKSUM info");
	torture_assert_int_equal(tctx,
		r->buffers[4].info->srv_cksum.type,
		CKSUMTYPE_HMAC_SHA1_96_AES_256,
		"srv_cksum");
	torture_assert_int_equal(tctx,
		r->buffers[4].info->srv_cksum.signature.length,
		12,
		"PAC_TYPE_SRV_CHECKSUM signature.length");

	torture_assert_int_equal(tctx, r->buffers[5].type, PAC_TYPE_KDC_CHECKSUM, "PAC_TYPE_KDC_CHECKSUM");
	torture_assert_int_equal(tctx, r->buffers[5]._ndr_size, 20, "PAC_TYPE_KDC_CHECKSUM _ndr_size");
	torture_assert(tctx, r->buffers[5].info != NULL, "PAC_TYPE_KDC_CHECKSUM info");
	torture_assert_int_equal(tctx,
		r->buffers[5].info->kdc_cksum.type,
		CKSUMTYPE_HMAC_MD5,
		"kdc_cksum");
	torture_assert_int_equal(tctx,
		r->buffers[5].info->kdc_cksum.signature.length,
		16,
		"PAC_TYPE_KDC_CHECKSUM signature.length");

	return true;
}

static bool PAC_CREDENTIAL_DATA_NDR_check(struct torture_context *tctx,
			    struct PAC_CREDENTIAL_DATA_NDR *r)
{
	torture_assert(tctx, r->ctr.data != NULL, "data");

	torture_assert_int_equal(tctx, r->ctr.data->credential_count, 1, "credential_count");
	torture_assert_int_equal(tctx,
		r->ctr.data->credentials[0].package_name.size,
		2*strlen_m("NTLM"),
		"package_name.size");
	torture_assert_int_equal(tctx,
		r->ctr.data->credentials[0].package_name.length,
		2*strlen_m("NTLM"),
		"package_name.length");
	torture_assert_str_equal(tctx,
		r->ctr.data->credentials[0].package_name.string,
		"NTLM",
		"package_name.string");
	torture_assert_int_equal(tctx,
		r->ctr.data->credentials[0].credential_size,
		sizeof(PAC_DATA_pkinit_PAC_CREDENTIAL_NTLM_SECPKG),
		"credential_size");
	torture_assert_data_blob_equal(tctx,
		data_blob_const(r->ctr.data->credentials[0].credential,
				r->ctr.data->credentials[0].credential_size),
		data_blob_const(PAC_DATA_pkinit_PAC_CREDENTIAL_NTLM_SECPKG,
				sizeof(PAC_DATA_pkinit_PAC_CREDENTIAL_NTLM_SECPKG)),
		"PAC_CREDENTIAL_NTLM_SECPKG credential");

	return true;
}

static bool PAC_CREDENTIAL_NTLM_SECPKG_check(struct torture_context *tctx,
					     struct PAC_CREDENTIAL_NTLM_SECPKG *r)
{
	torture_assert_int_equal(tctx, r->version, 0, "version");

	torture_assert_int_equal(tctx,
		r->flags,
		PAC_CREDENTIAL_NTLM_HAS_NT_HASH,
		"flags");

	torture_assert_data_blob_equal(tctx,
		data_blob_const(r->lm_password.hash,
				sizeof(r->lm_password.hash)),
		data_blob_const(PAC_DATA_pkinit_PAC_CREDENTIAL_NTLM_SECPKG+0x08,
				16),
		"lm_password");
	torture_assert_data_blob_equal(tctx,
		data_blob_const(r->nt_password.hash,
				sizeof(r->nt_password.hash)),
		data_blob_const(PAC_DATA_pkinit_PAC_CREDENTIAL_NTLM_SECPKG+0x18,
				16),
		"nt_password");

	return true;
}

struct torture_suite *ndr_krb5pac_suite(TALLOC_CTX *ctx)
{
	struct torture_suite *suite = torture_suite_create(ctx, "krb5pac");

	torture_suite_add_ndr_pull_validate_test(suite,
					PAC_DATA_RAW,
					PAC_DATA_data,
					NULL);
	/*
	 * We can't use torture_suite_add_ndr_pull_validate_test()
	 * here with PAC_DATA, as we don't match the unique
	 * pointer values inside PAC_LOGON_INFO, for these
	 * case where we have S-1-5-18-1, as extra sid.
	 */
	torture_suite_add_ndr_pull_test(suite,
					PAC_DATA,
					PAC_DATA_data,
					PAC_DATA_check);

	torture_suite_add_ndr_pull_validate_test(suite,
					PAC_DATA_RAW,
					PAC_DATA_data2,
					NULL);
	/*
	 * We can't use torture_suite_add_ndr_pull_validate_test()
	 * here with PAC_DATA, as we don't match the unique
	 * pointer values inside PAC_LOGON_INFO, for these
	 * case where we have S-1-5-18-1, as extra sid.
	 */
	torture_suite_add_ndr_pull_test(suite,
					PAC_DATA,
					PAC_DATA_data2,
					PAC_DATA_check2);

	torture_suite_add_ndr_pull_validate_test(suite,
					PAC_DATA_RAW,
					PAC_DATA_data3,
					NULL);
	torture_suite_add_ndr_pull_validate_test(suite,
					PAC_DATA,
					PAC_DATA_data3,
					NULL);

	torture_suite_add_ndr_pull_validate_test(suite,
					PAC_DATA_RAW,
					PAC_DATA_pkinit_AS,
					NULL);
	torture_suite_add_ndr_pull_validate_test(suite,
					PAC_DATA,
					PAC_DATA_pkinit_AS,
					PAC_DATA_pkinit);

	torture_suite_add_ndr_pull_validate_test(suite,
					PAC_DATA_RAW,
					PAC_DATA_pkinit_TGS,
					NULL);
	torture_suite_add_ndr_pull_validate_test(suite,
					PAC_DATA,
					PAC_DATA_pkinit_AS,
					PAC_DATA_pkinit);

	torture_suite_add_ndr_pull_validate_test(suite,
					PAC_CREDENTIAL_DATA_NDR,
					PAC_DATA_pkinit_PAC_CREDENTIAL_DATA_NDR,
					PAC_CREDENTIAL_DATA_NDR_check);

	torture_suite_add_ndr_pull_validate_test(suite,
					PAC_CREDENTIAL_NTLM_SECPKG,
					PAC_DATA_pkinit_PAC_CREDENTIAL_NTLM_SECPKG,
					PAC_CREDENTIAL_NTLM_SECPKG_check);

	return suite;
}
