/*
 * Copyright (C) 2025 The Phosh Developers
 *
 * SPDX-License-Identifier: GPL-3.0+
 *
 * Author: Evangelos Ribeiro Tzaras <devrtz@fortysixandtwo.eu>
 */


#pragma once

#include "lcb-message.h"

G_BEGIN_DECLS

LcbMessage    *lcb_message_new             (const char      *text,
                                            uint             channel,
                                            uint             message_code,
                                            uint             update,
                                            gint64           timestamp,
                                            LcbSeverityLevel severity,
                                            const char      *severity_subject,
                                            const char      *operator_code);

/* dynamic */
gboolean       lcb_message_has_been_updated (LcbMessage *self);
const char    *lcb_message_get_updated_by   (LcbMessage *self);

G_END_DECLS
