#ifndef HS_DIRECTORY_WINDOWS_EXT_H
#define HS_DIRECTORY_WINDOWS_EXT_H
#include <windows.h>

// define prototype to get size, offsets, and alignments
// (can't include <ntifs.h> because that only exists in WDK)
typedef struct {
    ULONG ReparseTag;
    USHORT ReparseDataLength;
    USHORT Reserved;
    union {
        struct {
            USHORT SubstituteNameOffset;
            USHORT SubstituteNameLength;
            USHORT PrintNameOffset;
            USHORT PrintNameLength;
            ULONG Flags;
            WCHAR PathBuffer[1];
        } SymbolicLinkReparseBuffer;
        struct {
            USHORT SubstituteNameOffset;
            USHORT SubstituteNameLength;
            USHORT PrintNameOffset;
            USHORT PrintNameLength;
            WCHAR PathBuffer[1];
        } MountPointReparseBuffer;
        struct {
            UCHAR DataBuffer[1];
        } GenericReparseBuffer;
    };
} HsDirectory_REPARSE_DATA_BUFFER;

#endif
