# Тіло запиту - Декілька параметрів

Тепер, коли ми розглянули використання `Path` та `Query`, розгляньмо більш просунуті способи оголошення тіла запиту в **FastAPI**.

## Змішування `Path`, `Query` та параметрів тіла запиту

По-перше, звісно, Ви можете вільно змішувати оголошення параметрів `Path`, `Query` та тіла запиту, і **FastAPI** правильно їх обробить.

Також Ви можете оголосити параметри тіла як необов’язкові, встановивши для них значення за замовчуванням `None`:

{* ../../docs_src/body_multiple_params/tutorial001_an_py310.py hl[18:20] *}

/// note | Примітка

Зверніть увагу, що в цьому випадку параметр `item`, який береться з тіла запиту, є необов'язковим, оскільки має значення за замовчуванням `None`.

///

## Декілька параметрів тіла запиту

У попередньому прикладі *операція шляху* очікувала JSON з атрибутами `Item`, наприклад:

```JSON
{
    "name": "Foo",
    "description": "The pretender",
    "price": 42.0,
    "tax": 3.2
}
```
Але Ви також можете оголосити декілька параметрів тіла, наприклад `item` та `user`:

{* ../../docs_src/body_multiple_params/tutorial002_py310.py hl[20] *}

У цьому випадку **FastAPI** розпізнає, що є кілька параметрів тіла (два параметри є моделями Pydantic).

Тому він використає назви параметрів як ключі (назви полів) у тілі запиту, очікуючи:

```JSON
{
    "item": {
        "name": "Foo",
        "description": "The pretender",
        "price": 42.0,
        "tax": 3.2
    },
    "user": {
        "username": "dave",
        "full_name": "Dave Grohl"
    }
}
```

/// note | Примітка

Зверніть увагу, що хоча `item` оголошено, так само як і раніше, тепер він очікується в тілі під ключем  `item`.

///

**FastAPI**  автоматично конвертує дані із запиту таким чином, щоб параметр `item` отримав свій вміст, і те ж саме стосується `user`.

Він виконає валідацію складених даних і задокументує їх відповідним чином у схемі OpenAPI та в автоматичній документації.

## Одиничні значення в тілі запиту

Так само як є `Query` і `Path` для визначення додаткових даних для параметрів запиту та шляху, **FastAPI** надає еквівалентний `Body`.

Наприклад, розширюючи попередню модель, Ви можете вирішити додати ще один ключ `importance` в те ж саме тіло запиту разом із `item` і `user`.

Якщо Ви оголосите його як є, то, оскільки це одиничне значення,  **FastAPI**  припускатиме, що це параметр запиту (query parameter).

Але Ви можете вказати **FastAPI** обробляти його як інший ключ тіла (body key), використовуючи `Body`:

{* ../../docs_src/body_multiple_params/tutorial003_an_py310.py hl[23] *}

У цьому випадку **FastAPI** очікуватиме тіло запиту у такому вигляді:

```JSON
{
    "item": {
        "name": "Foo",
        "description": "The pretender",
        "price": 42.0,
        "tax": 3.2
    },
    "user": {
        "username": "dave",
        "full_name": "Dave Grohl"
    },
    "importance": 5
}
```
Знову ж таки, **FastAPI** конвертуватиме типи даних, перевірятиме їх, створюватиме документацію тощо.

## Декілька body та query параметрів

Звісно, Ви можете оголошувати додаткові query параметри запиту, коли це необхідно, на додаток до будь-яких параметрів тіла запиту.

Оскільки за замовчуванням окремі значення інтерпретуються як параметри запиту, Вам не потрібно явно додавати `Query`, можна просто використати:

```Python
q: Union[str, None] = None
```

Або в Python 3.10 та вище:

```Python
q: str | None = None
```

Наприклад:

{* ../../docs_src/body_multiple_params/tutorial004_an_py310.py hl[28] *}


/// info | Інформація

`Body` також має ті самі додаткові параметри валідації та метаданих, що й `Query`, `Path` та інші, які Ви побачите пізніше.

///

## Вкладений поодинокий параметр тіла запиту

Припустимо, у вас є лише один параметр тіла запиту `item` з моделі Pydantic `Item`.

За замовчуванням **FastAPI** очікуватиме, що тіло запиту міститиме вміст безпосередньо.

Але якщо Ви хочете, щоб він очікував JSON з ключем `item`, а всередині — вміст моделі (так, як це відбувається при оголошенні додаткових параметрів тіла), Ви можете використати спеціальний параметр `Body` — `embed`:

```Python
item: Item = Body(embed=True)
```

як у прикладі:

{* ../../docs_src/body_multiple_params/tutorial005_an_py310.py hl[17] *}

У цьому випадку **FastAPI** очікуватиме тіло запиту такого вигляду:

```JSON hl_lines="2"
{
    "item": {
        "name": "Foo",
        "description": "The pretender",
        "price": 42.0,
        "tax": 3.2
    }
}
```

замість:

```JSON
{
    "name": "Foo",
    "description": "The pretender",
    "price": 42.0,
    "tax": 3.2
}
```

## Підсумок

Ви можете додавати кілька параметрів тіла до Вашої *функції операції шляху* (*path operation function*), навіть якщо запит може мати лише одне тіло.

Але **FastAPI** обробить це, надасть Вам потрібні дані у функції, перевірить їх та задокументує коректну схему в *операції шляху*.

Також Ви можете оголошувати окремі значення, які будуть отримані як частина тіла запиту.

Крім того, Ви можете вказати **FastAPI**  вбудовувати тіло в ключ, навіть якщо оголошено лише один параметр.
